﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="SectionTrace.ascx.vb" Inherits="Web.SectionTrace" %>
<%@ Register Src="~/private/traceability/controles/cu-codigoopcion.ascx" TagName="cu_codigoopcion" TagPrefix="uc" %>
<%@ Register Src="~/private/traceability/controles/cu-portgraphic.ascx" TagName="cu_portgraphic" TagPrefix="uc" %>

<asp:UpdatePanel runat="server" ID="UpdatePanelCuTrace" UpdateMode="Conditional" ChildrenAsTriggers="false">
    <ContentTemplate>

        <!-- Vista general: información de los puertos (libres o reservados) -->
        <asp:Panel ID="panelVistaGeneral" runat="server" Visible="true" CssClass="trace">
            <div class="mode-panel"></div>
            <asp:UpdatePanel class="rec-block" runat="server" ID="UpdatePanelBotonesHome2" UpdateMode="Conditional">
                <ContentTemplate>
                    <div class="container">
                        <div class="text-container">
                            <div class="text-holder">
                                <h2 style="min-height: 40px !important;">Monitorización de trabajos</h2>
                                <span class="subtitle"><span>Estado de los puertos</span></span>
                            </div>
                        </div>
                    </div>
                    <div class="ports-block">
                        <div class="container">
                            <ul class="ports-list">
                                <asp:Repeater ID="repeater_puertos" runat="server" OnItemCommand="repeater_puertos_ItemCommand">
                                    <ItemTemplate>
                                        <li style="width: 50%;">
                                            <div class="port-image">
                                                <img runat="server" visible='<%# Eval("Visible")%>' src='<%# Eval("Imagen")%>' width="39" height="159" />
                                            </div>
                                            <div class="holder">
                                                <asp:Label CssClass="title" runat="server" Text='<%# Eval("Punta")%>'></asp:Label>
                                                <asp:Label CssClass="port-temperature" Text='<%# Eval("Temperatura") + " / " + Eval("EstadoPort")%>' runat="server"></asp:Label>
                                                <asp:Label CssClass="port-temperature" Text='<%# Eval("Usuario")%>' runat="server"></asp:Label>
                                                <asp:Label CssClass="port-temperature" Text='<%# Eval("IdLector")%>' runat="server"></asp:Label>
                                            </div>
                                        </li>
                                    </ItemTemplate>
                                </asp:Repeater>
                            </ul>
                        </div>
                    </div>
                    <asp:Label ID="lblSecuencia" runat="server"></asp:Label>
                </ContentTemplate>
                <Triggers>
                    <asp:AsyncPostBackTrigger ControlID="repeater_puertos" EventName="ItemCommand" />
                </Triggers>
            </asp:UpdatePanel>

            <!-- Update progress: Zonas que tienen que mostrar un updateprogress si se realiza una acción -->
            <asp:UpdateProgress ID="UpdateProgressCuTraceHome2" runat="server" AssociatedUpdatePanelID="UpdatePanelBotonesHome2" DisplayAfter="100">
                <ProgressTemplate>
                    <asp:Image ID="img_ajax_loading_CuTraceHome2" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered" />
                </ProgressTemplate>
            </asp:UpdateProgress>

        </asp:Panel>

        <!-- Modo trabajo: Monitoziación de un puerto esta estación -->
        <asp:Panel ID="panelVistaPuerto" runat="server" class="block content-inner trace">

            <!-- Cabecera de cambio de puerto -->
            <div class="table-styles-block">

                <div class="station-demo-block">

                    <!-- Monitorización de parámetros y gráfica -->
                    <asp:UpdatePanel runat="server" ID="UpdatePanelPuertoActual" UpdateMode="Conditional" ChildrenAsTriggers="false">
                        <ContentTemplate>
                            <div class="add-panel panel-blue text-left">
                                <p runat="server" id="lblInfoPuerto">Station: Estacion - Port: X</p>
                            </div>
                            <div class="station-details-tabs">
                                <div id="divMonitorizacionPuertoActual" class="slide" runat="server" visible="false">
                                    <div class="station-parameters portgraphic">
                                        <uc:cu_portgraphic ID="cu_portgraphic" runat="server" />
                                    </div>
                                </div>
                            </div>
                        </ContentTemplate>
                    </asp:UpdatePanel>

                    <!-- Si se ha seleccionado una operación o tarea -->
                    <asp:Panel ID="panelPortReservedOptionCode" runat="server" CssClass="station-details-table">
                        <uc:cu_codigoopcion ID="cu_codigoopcion" runat="server" />
                    </asp:Panel>

                </div>
            </div>
        </asp:Panel>

        <!--Panel de titulo recurso -->
        <asp:Panel ID="PanelTexto" runat="server" Style="display: none; z-index: 100002;" CssClass="error-message ">
            <div class="holder">
                <div class="legal">
                    <div class="jcf-scrollable" style="height: 380px; overflow: hidden; font-size: 16px !important; text-align: left !important; padding: 5px; margin: 0 auto !important;">
                        <asp:Literal ID="littexto" runat="server"></asp:Literal>
                    </div>
                </div>
                <br />
                <a id="btnCancelar_Msg" href="#" runat="server" class="btn">Ok</a>
            </div>
        </asp:Panel>
        <ajaxToolkit:ModalPopupExtender ID="MPE_PanelTexto" runat="server" TargetControlID="hdnPanelTexto" PopupControlID="PanelTexto" BackgroundCssClass="" CancelControlID="btnCancelar_Msg" DropShadow="false" PopupDragHandleControlID="" />
        <asp:HiddenField ID="hdnPanelTexto" runat="server" />

        <!--- Controles ocultos y timer-->
        <asp:HiddenField ID="hdnPuerto" runat="server" Value="0" />
        <asp:HiddenField ID="hdnWorkSupport" runat="server" />
        <asp:HiddenField ID="hdnImagenPunta" runat="server" />
        <asp:HiddenField ID="hdnTempo" runat="server" Value="0" />
        <asp:HiddenField ID="hdnVolver" runat="server" />

        <asp:Timer ID="TimerUpdateCuTrace" runat="server" OnTick="TimerUpdateCuTrace_Tick" Interval="1000" Enabled="false"></asp:Timer>

    </ContentTemplate>
</asp:UpdatePanel>

<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderCuTrace" TargetControlID="UpdatePanelCuTrace" BehaviorID="animation" runat="server">
    <Animations>    
        <OnUpdated>
            <Sequence>
                <ScriptAction Script="initRefreshFunctions($('div.trace'));" />
            </Sequence>
        </OnUpdated>
    </Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>
